#ifdef _VERSION_CHECK_
	#ifndef MSET
		#ifndef _NOT_INSTANCED_
			
			#version 120
			#extension GL_EXT_gpu_shader4 : enable          
				
		#endif
	#endif
#endif
	
varying vec2 		texcoord;
//varying vec4		pos;
uniform float 		fade;
varying float		fadeAlpha;
uniform vec4		colorMod;

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 		WorldPoses;
#endif

//uniform mat4	WTM;

void main()
{
	#ifndef _NOT_INSTANCED_
	
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
		fadeAlpha=MTX[3].w;
		MTX[3].w=1.0;
		gl_Position = (gl_ModelViewProjectionMatrix*MTX)*gl_Vertex;//ftransform();
		
		MTX=gl_ModelViewMatrix*MTX;
		vec4 pos=MTX*gl_Vertex;
		
	#else
	
		fadeAlpha=fade;
		gl_Position = (gl_ModelViewProjectionMatrix)*gl_Vertex;//ftransform();
				
		vec4 pos=gl_ModelViewMatrix*gl_Vertex;
		
	#endif
	
	float dist=(length(pos.xyz)-fadeAlpha*0.6)/(fadeAlpha*0.4);//*0.8);
	fadeAlpha=(1.0 - (clamp(dist,0.0,1.0)))*colorMod.a;

	texcoord = gl_MultiTexCoord0.st;

}